import 'package:flutter/material.dart';


import '../../features/auth/login/view/login_view.dart';
import '../../features/auth/splash/view/splash_view.dart';
import '../../features/customers/model/firmalar.dart';
import '../../features/customers/view/activities/company_activity_page.dart';
import '../../features/customers/view/activities/create_activity.dart';
import '../../features/customers/view/companies/create_company.dart';
import '../../features/home/view/home_custom.dart';
import 'page_route.dart';

final class AppRouter {
  static Route onGenerateRoute(RouteSettings settings) {
    switch (settings.name) {
      case "/":
        return MaterialPageRoute(
            builder: (context) => const SplashView(), settings: settings);
      case "/login":
        return MaterialPageRoute(
            builder: (context) => const LoginView(), settings: settings);
      case "/home":
        return CustomPageRoute(child: HomeCustom(), settings: settings);
      case "/addcompany":
        return MaterialPageRoute(
            builder: (context) => const CreateCompany(), settings: settings);
      case "/addactivity":
        return MaterialPageRoute(
            builder: (context) => const CreateActivity(), settings: settings);
      case "/companyactivity":
        final args = settings.arguments as Firmalar;
        return CustomPageRoute(
            child: CompanyActivityPage(firma: args),
            settings: settings,
            direction: AxisDirection.up);
      default:
        return MaterialPageRoute(
            builder: (context) => const SplashView(), settings: settings);
    }
  }
}
