import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import '../../constants/color_constants.dart';

final class AppTheme {
  AppTheme(this.context);
  final BuildContext context;

  ThemeData get customAppTheme => ThemeData(
      appBarTheme: const AppBarTheme(
          systemOverlayStyle: SystemUiOverlayStyle.dark,
          surfaceTintColor: Colors
              .transparent // kaydırmalardan appbar rengi değişmesin diye transparent yaptık
          ),
      primaryColor: Colors.orange,
      textSelectionTheme: TextSelectionThemeData(
        cursorColor: ColorsConstants.instance.baseTheme,
      ),
      bottomSheetTheme: const BottomSheetThemeData(
          dragHandleSize: Size(kBottomNavigationBarHeight, 4)),
      textTheme: customTextTheme,
      fontFamily: 'Raleway',
      progressIndicatorTheme: ProgressIndicatorThemeData(
          color: ColorsConstants.instance.baseTheme));

  TextTheme get customTextTheme => TextTheme(
      headlineSmall:
          Theme.of(context).textTheme.headlineSmall?.copyWith(fontSize: 14));

  static ButtonStyle get mainColorRoundedButton => TextButton.styleFrom(
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(5),
      ),
      backgroundColor: ColorsConstants.instance.baseTheme);
}
