
import 'package:shared_preferences/shared_preferences.dart';

class CacheManager {
  static CacheManager? _instance;
  static CacheManager get instance {
    _instance ??= CacheManager._init();
    return _instance!;
  }

  late SharedPreferences prefs;

  CacheManager._init() {
    initPreferences();
  }

  Future<void> initPreferences() async {
    prefs = await SharedPreferences.getInstance();
  }

  Future<String> getValue(String key) async {
    return prefs.getString(key) ?? '';
  }

  Future<void> addValue(String key, String value) async {
    await prefs.setString(key, value);
  }

  Future<void> removeValue(String key) async {
    await prefs.remove(key);
  }
}
