import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../data/repo/activities_repository.dart';
import '../../../data/repo/calendar_repository.dart';
import '../../../data/repo/message_repository.dart';
import '../../../features/auth/login/cubit/login_cubit.dart';
import '../../../features/auth/splash/cubit/splash_cubit.dart';
import '../../../features/calendar/cubit/calendar_cubit.dart';
import '../../../features/calendar/cubit/suggestion_cubit.dart';
import '../../../features/customers/cubit/activity_cubit.dart';
import '../../../features/customers/cubit/company_personal_cubit.dart';
import '../../../features/customers/cubit/customers_cubit.dart';
import '../../../features/home/cubit/home_custom_cubit.dart';
import '../../../features/human_resources/cubit/employee_cubit.dart';
import '../../../features/message/cubit/message_cubit.dart';
import '../../../features/permissions/cubit/permission_cubit.dart';
import '../../../features/profile/cubit/profile_cubit.dart';
import '../../../features/projects/cubit/mission_employee_notes_cubit.dart';
import '../../../features/projects/cubit/missions_cubit.dart';
import '../../../features/projects/cubit/project_cubit.dart';
import '../../../features/projects/cubit/projects_stage_cubit.dart';
import '../../cubits/dropdown_cubit.dart';
import '../../cubits/notification_cubit.dart';

final class AppBlocProviders extends StatelessWidget {
  final Widget child;

  const AppBlocProviders({super.key, required this.child});

  @override
  Widget build(BuildContext context) {
    return MultiBlocProvider(
      providers: [
        BlocProvider(
          create: (context) => SplashCubit(
            LoginCubit(HomeCustomCubit()),
            HomeCustomCubit(),
          ),
        ),
        BlocProvider(create: (context) => LoginCubit(HomeCustomCubit())),
        BlocProvider(create: (context) => ProfileCubit()),
        BlocProvider(create: (context) => NotificationCubit()),
        BlocProvider(create: (context) => HomeCustomCubit()),
        BlocProvider(
          create: (context) => ProjectCubit()
            ..changeFilterProjectList(
                0,
                context.read<LoginCubit>().id,
                context.read<LoginCubit>().token,
                context.read<LoginCubit>().userfirmId,
                context.read<LoginCubit>().tip),
          lazy: true,
        ),
        BlocProvider(
            create: (context) => MissionsCubit()
              ..tumGorevleriListele(context.read<LoginCubit>().token,
                  context.read<LoginCubit>().id, 0)),
        BlocProvider(create: (context) => MissionEmployeeCubit()),
        BlocProvider(create: (context) => ProjectStageCubit()),
        BlocProvider(create: (context) => DropdownCubit()),
        BlocProvider(
          create: (context) =>
              ActivityCubit(activitiesRepository: ActivitiesRepository()),
          lazy: true,
        ),
        BlocProvider(
          create: (context) => CustomersCubit(),
          lazy: true,
        ),
        BlocProvider(
          create: (context) => CompanyPersonalCubit(),
          lazy: true,
        ),
        BlocProvider(create: (context) => EmployeeCubit(), lazy: true),
        BlocProvider(
          create: (context) => PermissionCubit(),
          lazy: true,
        ),
        BlocProvider(create: (context) => CalendarCubit(CalendarRepository())),
        BlocProvider(create: (context) => SuggestionCubit()),
        BlocProvider(create: (context) => MessageCubit(MessageRepository())),
      ],
      child: child,
    );
  }
}
