import 'package:flutter/material.dart';

extension ContextExtension on BuildContext {
  double dynamicHeight(double value) => MediaQuery.sizeOf(this).height * value;
  double dynamicWidth(double value) => MediaQuery.sizeOf(this).width * value;

  ThemeData get themeData => Theme.of(this);
  // eski kodlar
  // double dynamicHeight(double value) => MediaQuery.of(this).size.height * value;
  // double dynamicWidth(double value) => MediaQuery.of(this).size.width * value;
}
